{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 05.09.98 - 21:45:42 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
    Windows,
    Messages,
    SysUtils,
    Classes,
    Graphics,
    Controls,
    Forms,
    Dialogs,
    Menus,
    ExtCtrls,
    StdCtrls,
    ComCtrls,
    Buttons,
    MMSystem,
    MMObj,
    MMUtils,
    MMAbout,
    MMHTimer,
    MMWave,
    MMDSWOut,
    MMLEDS,
    MMWaveIO,
    MMDesign,
    MMConect,
    MMDSPObj,
    MMCstDlg,
    MMDIBCv,
    MMLevel,
    MMButton,
    MMRingBf,
    MMACMCvt, MMHook;

const
    MaxWaves = 2;

type
   TDisplayPanel = record
      Mode  : TMMLEDMode;
      SRate : TMMLEDPanel;
      BitLen: TMMLEDPanel;
      oMSec : Word;
      MSec  : TMMLEDDigit;
      oSec  : Word;
      Sec   : TMMLEDDigit;
      oMin  : Word;
      Min   : TMMLEDDigit;
   end;

   TWavePanel = record
      Name       : TLabel;
      Position   : TProgressBar;
      Volume     : TTrackBar;
      Frequency  : TTrackBar;
      Panning    : TTrackBar;
      PlayBtn    : TMMSpeedButton;
      PauseBtn   : TMMSpeedButton;
      StopBtn    : TMMSpeedButton;
      WaveFile   : TMMWaveFile;
      WaveOut    : TMMDSWaveOut;
      Display    : TDisplayPanel;
      BytesPlayed: Longint;
   end;

type
  TMainForm = class(TForm)
    Bevel1: TBevel;
    MMHiTimer: TMMHiTimer;
    MMWaveOpenDialog: TMMWaveOpenDialog;
    Panel1: TPanel;
    Bevel12: TBevel;
    Label25: TLabel;
    Label26: TLabel;
    Label27: TLabel;
    trackVolume1: TTrackBar;
    trackFrequency1: TTrackBar;
    trackPanning1: TTrackBar;
    barPosition1: TProgressBar;
    Display1: TPanel;
    mm12: TMMLEDDigit;
    mm1: TMMLEDDigit;
    ss12: TMMLEDDigit;
    Colon1: TMMLEDDigit;
    Label12: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    LEDMode1: TMMLEDMode;
    ss1: TMMLEDDigit;
    Colon2: TMMLEDDigit;
    ms13: TMMLEDDigit;
    ms12: TMMLEDDigit;
    ms1: TMMLEDDigit;
    SRate1: TMMLEDPanel;
    BitLen1: TMMLEDPanel;
    btnPlay1: TMMSpeedButton;
    btnPause1: TMMSpeedButton;
    btnStop1: TMMSpeedButton;
    btnClose1: TMMSpeedButton;
    lblName1: TLabel;
    MMDSWaveOut1: TMMDSWaveOut;
    MMDSWaveOut2: TMMDSWaveOut;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    About: TMenuItem;
    Panel2: TPanel;
    Bevel2: TBevel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    btnPlay2: TMMSpeedButton;
    btnPause2: TMMSpeedButton;
    trackVolume2: TTrackBar;
    trackFrequency2: TTrackBar;
    trackPanning2: TTrackBar;
    barPosition2: TProgressBar;
    Display2: TPanel;
    mm22: TMMLEDDigit;
    mm2: TMMLEDDigit;
    ss22: TMMLEDDigit;
    MMLEDDigit4: TMMLEDDigit;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    LEDMode2: TMMLEDMode;
    ss2: TMMLEDDigit;
    MMLEDDigit6: TMMLEDDigit;
    ms23: TMMLEDDigit;
    ms22: TMMLEDDigit;
    ms2: TMMLEDDigit;
    lblName2: TLabel;
    SRate2: TMMLEDPanel;
    BitLen2: TMMLEDPanel;
    btnStop2: TMMSpeedButton;
    btnClose2: TMMSpeedButton;
    ckbLoop1: TCheckBox;
    CheckBox1: TCheckBox;
    MMLevel1: TMMLevel;
    MMConnector1: TMMConnector;
    MMLevel2: TMMLevel;
    MMConnector2: TMMConnector;
    MMWaveFile1: TMMWaveFile;
    MMWaveFile2: TMMWaveFile;
    MMRingBuffer1: TMMRingBuffer;
    MMRingBuffer2: TMMRingBuffer;
    MMDesigner1: TMMDesigner;
    MMPCMConverter1: TMMPCMConverter;
    MMPCMConverter2: TMMPCMConverter;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure OpenClick(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure btnPlayClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
    procedure trackVolumeChange(Sender: TObject);
    procedure trackFrequencyChange(Sender: TObject);
    procedure trackPanningChange(Sender: TObject);
    procedure MMHiTimerTimer(Sender: TObject);
    procedure AboutClick(Sender: TObject);
    procedure btnPauseClick(Sender: TObject);
    procedure MMDSWaveOutStart(Sender: TObject);
    procedure MMDSWaveOutStop(Sender: TObject);
    procedure MMDSWaveOutRestart(Sender: TObject);
    procedure MMDSWaveOutPause(Sender: TObject);
    procedure MMDSWaveOut1BufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
    procedure ckbLoopClick(Sender: TObject);
    procedure MMDSWaveOutLooping(Sender: TObject);
  private
    procedure WMGetMinMaxInfo(Var Msg: TWMGetMinMaxInfo); message WM_GETMINMAXINFO;
    procedure WMInitMenuPopup(Var Msg: TWMInitMenuPopup); message WM_INITMENUPOPUP;
    procedure WMNCHitTest(Var Msg: TWMNCHitTest); message WM_NCHitTest;
  public
    NumWaves: integer;
    WavePanels: array[1..MaxWaves] of TWavePanel;
    procedure SetupControls;
    procedure UpdateDisplay(Tag: Longint);
    procedure DrawTime(Tag: Longint);
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.WMGetMinMaxInfo(Var Msg: TWMGetMinMaxInfo);
begin
   with Msg.MinMaxInfo^ do
   begin
      ptMinTrackSize.X := Width;                       { Minimum width  }
      ptMinTrackSize.Y := Height;                      { Minimum height }
      ptMaxTrackSize.X := Width;                       { Maximum width  }
      ptMaxTrackSize.Y := Height;                      { Maximum height }
   end;
   Msg.Result := 0;          { Tell windows you have changed minmaxinfo }
   inherited;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.WMInitMenuPopup(Var Msg: TWMInitMenuPopup);
begin
   inherited;
   if Msg.SystemMenu then
      EnableMenuItem(Msg.MenuPopup, SC_SIZE, MF_BYCOMMAND or MF_GRAYED);
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.WMNCHitTest(Var Msg: TWMNCHitTest);
begin
   inherited;
   with Msg do
     if Result in [HTLEFT, HTRIGHT, HTBOTTOM, HTBOTTOMRIGHT,
                   HTBOTTOMLEFT, HTTOP, HTTOPRIGHT, HTTOPLEFT] then
        Result:= Windows.HTNOWHERE;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.SetupControls;
var
   i: integer;

begin
   for i := 1 to MaxWaves do
   begin
      WavePanels[i].Name := TLabel(FindComponent('lblName'+IntToStr(i)));
      WavePanels[i].Position := TProgressBar(FindComponent('barPosition'+IntToStr(i)));
      WavePanels[i].Volume := TTrackBar(FindComponent('trackVolume'+IntToStr(i)));
      WavePanels[i].Frequency := TTrackBar(FindComponent('trackFrequency'+IntToStr(i)));
      WavePanels[i].Panning := TTrackBar(FindComponent('trackPanning'+IntToStr(i)));
      WavePanels[i].WaveFile := TMMWaveFile(FindComponent('MMWaveFile'+IntToStr(i)));
      WavePanels[i].WaveOut := TMMDSWaveOut(FindComponent('MMDSWaveOut'+IntToStr(i)));

      WavePanels[i].PlayBtn := TMMSpeedButton(FindComponent('btnPlay'+IntToStr(i)));
      WavePanels[i].PauseBtn := TMMSpeedButton(FindComponent('btnPause'+IntToStr(i)));
      WavePanels[i].StopBtn := TMMSpeedButton(FindComponent('btnStop'+IntToStr(i)));

      WavePanels[i].Display.Mode := TMMLEDMode(FindComponent('LEDMode'+IntToStr(i)));
      WavePanels[i].Display.SRate := TMMLEDPanel(FindComponent('SRate'+IntToStr(i)));
      WavePanels[i].Display.BitLen := TMMLEDPanel(FindComponent('BitLen'+IntToStr(i)));

      WavePanels[i].Display.MSec := TMMLEDDigit(FindComponent('ms'+IntToStr(i)));
      WavePanels[i].Display.Sec := TMMLEDDigit(FindComponent('ss'+IntToStr(i)));
      WavePanels[i].Display.Min := TMMLEDDigit(FindComponent('mm'+IntToStr(i)));
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.FormCreate(Sender: TObject);
begin
   NumWaves := 0;
   SetupControls;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
var
   i: integer;
begin
   MMHiTimer.Enabled := False;
   for i := 1 to MaxWaves do WavePanels[i].WaveOut.Close;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.Exit1Click(Sender: TObject);
begin
   Close;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.AboutClick(Sender: TObject);
begin
   Show_AboutBox(0);
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.OpenClick(Sender: TObject);
var
   i: integer;

begin
   if MMWaveOpenDialog.Execute then
   begin
      for i := 0 to ComponentCount-1 do
      begin
         if (Components[i] is TPanel) then
         with TPanel(Components[i]) do
         begin
            if not Visible and (Tag > 0) then
            with WavePanels[Tag] do
            begin
               WaveFile.LoadFromFile(MMWaveOpenDialog.FileName);
               Name.Caption := ExtractFileName(MMWaveOpenDialog.FileName)+'  '+IntToStr(WaveFile.Wave.FileSize div 1024) + ' Kb';
               Volume.Position := 400;
               Frequency.Position := WaveFile.Wave.SampleRate;
               WaveOut.Frequency := Frequency.Position;
               Panning.Position := 400;
               Position.Max := WaveFile.Wave.DataSize div 1024;
               Position.Position := 0;
               Top := MainForm.Height;

               StopBtn.Enabled := False;
               PlayBtn.Enabled := True;
               PauseBtn.Enabled := True;

               UpdateDisplay(Tag);
               MMHiTimer.Enabled := True;

               Visible := True;

               inc(NumWaves);
               if (NumWaves = MaxWaves) then Open1.Enabled := False;
               break;
            end;
         end;
      end;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.MMDSWaveOutStart(Sender: TObject);
begin
   with (Sender as TMMDSWaveOut) do
   begin
      WavePanels[Tag].StopBtn.Enabled := True;
      WavePanels[Tag].PlayBtn.Down := True;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.MMDSWaveOutPause(Sender: TObject);
begin
   with (Sender as TMMDSWaveOut) do
   begin
      WavePanels[Tag].PauseBtn.Down := True;
      WavePanels[Tag].PlayBtn.Enabled := True;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.MMDSWaveOutRestart(Sender: TObject);
begin
   with (Sender as TMMDSWaveOut) do
   begin
      WavePanels[Tag].PauseBtn.Down := False;
      WavePanels[Tag].PlayBtn.Down := True;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.MMDSWaveOutStop(Sender: TObject);
begin
   with (Sender as TMMDSWaveOut) do
   begin
      WavePanels[Tag].WaveOut.Close;
      WavePanels[Tag].StopBtn.Enabled := False;
      WavePanels[Tag].PlayBtn.Down := False;
      WavePanels[Tag].PauseBtn.Down := False;
      WavePanels[Tag].Position.Position := 0;
      DrawTime(Tag);
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.MMDSWaveOut1BufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
begin
   with (Sender as TMMDSWaveOut) do
   begin
      WavePanels[Tag].Position.Position := WavePanels[Tag].WaveFile.Wave.Position;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.MMDSWaveOutLooping(Sender: TObject);
begin
   with (Sender as TMMDSWaveOut) do
   begin
      WavePanels[Tag].Position.Position := 0;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnPlayClick(Sender: TObject);
Var
   State: TMMDSWaveOutState;

begin
   with (Sender as TMMSpeedButton).Parent do
   begin
      with WavePanels[Tag] do
      try
         State := WaveOut.State;
         if (dssPause in State) and (dssPlay in State) then
            WaveOut.Restart
         else WaveOut.Start;

         BytesPlayed := 0;
         Frequency.Position := WaveOut.Frequency;
         UpdateDisplay(Tag);

         PlayBtn.Down := True;

      except
         PlayBtn.Down := False;
         raise
      end;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnPauseClick(Sender: TObject);
Var
   State: TMMDSWaveOutState;

begin
   with (Sender as TMMSpeedButton).Parent do
   begin
      with WavePanels[Tag] do
      try
         State := WaveOut.State;
         if not (dssPause in State) then
            WaveOut.Pause
         else if (dssPlay in State) then
            WaveOut.Restart
         else WaveOut.Stop;

      except
         PauseBtn.Down := False;
         raise;
      end;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnStopClick(Sender: TObject);
begin
   with (Sender as TMMSpeedButton).Parent do
   begin
      WavePanels[Tag].WaveOut.Stop;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnCloseClick(Sender: TObject);
begin
   with (Sender as TMMSpeedButton).Parent do
   begin
      WavePanels[Tag].WaveOut.Close;

      dec(NumWaves);
      if (NumWaves < MaxWaves) then Open1.Enabled := True;

      if (NumWaves = 0) then MMHiTimer.Enabled := False;

      Visible := False;
   end;
end;
  
{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.trackVolumeChange(Sender: TObject);
begin
   with (Sender as TTrackBar).Parent do
   begin
      WavePanels[Tag].WaveOut.Volume := (TTrackBar(Sender).Position+(-400))*10;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.trackFrequencyChange(Sender: TObject);
begin
   with (Sender as TTrackBar).Parent do
   begin
      WavePanels[Tag].WaveOut.Frequency := TTrackBar(Sender).Position;
      UpdateDisplay(Tag);
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.trackPanningChange(Sender: TObject);
begin
   with (Sender as TTrackBar).Parent do
   begin
      WavePanels[Tag].WaveOut.Panning := (TTrackBar(Sender).Position+(-400))*10;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.ckbLoopClick(Sender: TObject);
begin
   with (Sender as TCheckBox).Parent do
   begin
      WavePanels[Tag].WaveOut.Looping := TCheckBox(Sender).Checked;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.MMHiTimerTimer(Sender: TObject);
var
   i: integer;

begin
   for i := 0 to ComponentCount-1 do
   begin
      if (Components[i] is TPanel) then
      with TPanel(Components[i]) do
      begin
          if Visible and (Tag > 0) then
             if (dssOpen in WavePanels[Tag].WaveOut.State) then
             begin
                DrawTime(Tag);
             end;
      end;
   end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.UpdateDisplay(Tag: Longint);
begin
   with WavePanels[Tag], WavePanels[Tag].Display do
   begin
      SRate.Value := WaveOut.Frequency;
      BitLen.Value := WaveFile.Wave.BitLength;
      Mode.Mode := WaveFile.Wave.Mode;
   end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.DrawTime(Tag: Longint);
Var
   nHour, nMin, nSec, nMSec: Word;

begin
   with WavePanels[Tag], WavePanels[Tag].Display do
   begin
      TimeDecode(WaveOut.Position, nHour, nMin, nSec, nMSec);

     if (oMSec <> nMSec) then
     begin
          MSec.Value := nMSec;
          oMSec := nMSec;
     end;

     if (oSec <> nSec) then
     begin
          Sec.Value := nSec;
          oSec := nSec;
     end;

     if (oMin <> nMin) then
     begin
          Min.Value := nMin;
          oMin := nMin;
     end;
   end;
end;

end.
